%% test for number of common factors in DTSM risk factors
clc;clear;
M = csvread('S:\RiddellS\MBauer\Nominal_Data_Replicate_code\data_dY.csv',1,1);

%% Bai-Ng

regime = M(:,1);

rmax=5;
DEMEAN=2;

disp(sprintf('Demean %d',DEMEAN));
disp('determining number of factors');
for (j = 1:4)
    fprintf('regime %u \n', j);
    x = M(regime==j,2:end);
    disp(sprintf('T= %d N= %d',size(x)));
    for i=1:2;
        disp([nbpiid(x,rmax,i,DEMEAN)   nbplog(x,rmax,i,DEMEAN)]);
    end;    
end;

%% onatski
disp('determine number of factors')
for (i = 1:5)
    N = onatski(M(regime==i,2:end)',2);
    fprintf('regime %u -- number of factors %u \n', [i,N]);
end
% depends on rmax!

disp('test whether number of factors is ONE')
for (i = 1:5)
    pvalue = statico(M(regime==i,:)',1,2);
    %%pvalue = dynamico(M(regime==i,2:end)',1,2);
    fprintf('regime %u -- p-value %6.4f \n', [i,pvalue]);
end
% accepts for macro and other, rejects for policy

disp('test whether number of factors is TWO')
for (i = 1:5)
    pvalue = statico(M(regime==i,2:end)',2,3);
    fprintf('regime %u -- p-value %6.4f \n', [i,pvalue]);
end
% accepts for policy, rejects for others (note H_1 is that N>2)




