## estimate Q-dynamics for daily Eurodollar futures
## objective function: Q-likelihood of CHANGES

rm(list=ls())
source("R/dtsm_functions.r")
source("R/init.r")
source("R/news_fns.r")

## currently set up for:
## 1AA (unit eigenvalue/rep eigenvalue)
dir.res.file <- "/R/estimates/results_yfut_1aa.RData"
res.file <- paste (getwd(), dir.res.file, sep = "", collapse = NULL)


##########################################################
## ESTIMATION of Q parameters

reparam <- function(lambda){
  theta <- lambda[1:(N-2)]^2/(1+lambda[1:(N-2)]^2)
  reparam <- theta
}
unreparam <- function(theta){
  lambda <- (theta[1:(N-2)]/(1-theta[1:(N-2)]))^.5
  unreparam <- lambda
}
get.lamQ.X <- function(theta) {
#  lamQ.X <- theta[1:N]
  lamQ.X <- c(1,theta[1],theta[1])
#  lamQ.X <- c(1, theta)
}

llk <- function(theta) {
  lamQ.X <- get.lamQ.X(theta)
  PhiQ.X <- get.PhiQ.X(lamQ.X)
  dY.hat <- dY.fitted(dP, P, W, PhiQ.X)
  errors <- dY - dY.hat
  sq.errors <- errors^2
  ## concentrate out measurement error variance
  T <- dim(sq.errors)[1]
  J <- dim(sq.errors)[2]
  ## concentrate out measurement error variance
  sigma.e <- sqrt( sum(sq.errors)/T/(J-N) )
  ## log likelihood contributions
  llk <- -(J-N)*.5*log(2*pi)-(J-N)*log(sigma.e)-.5*rowSums(sq.errors)/sigma.e^2
}

obj <- function(lambda) {
  theta <- reparam(lambda)
  obj <- -sum(llk(theta))
}

dtsm.results <- function(lambda) {
  ## look at results
  theta <- reparam(lambda)
  lamQ.X <- get.lamQ.X(theta)
  PhiQ.X <- get.PhiQ.X(lamQ.X)

  cat("*** DTSM RESULTS ***\n")
  cat("eigenvalues under Q = ", lamQ.X, "\n")

  dY.hat <- dY.fitted(dP, P, W, PhiQ.X)
  errors <- dY - dY.hat
  sq.errors <- errors^2

  rmse <- sqrt( mean(sq.errors) )*10000*n.days
  cat("RMSE (bps) = ", rmse,"\n")

  L <- sum(llk(theta))
  cat("log-likelihood = ", L,"\n")

  dtsm.results <- list(L=L, theta.hat=theta, lamQ.X=lamQ.X,rinfQ=NA)
}

## preliminary optimization
## starting values
lambda <- unreparam(starting.lamQ(N-2))
dtsm.results(lambda)

## preliminary optimization
res1 <- optim(lambda, obj, control=list(trace=0,maxit=10000,reltol=1e-8))
print(res1)
lambda <- res1$par
#res1 <- optim(lambda, obj, method="BFGS", control=list(trace=3,maxit=10000,reltol=1e-8))
#print(res1)
lambda <- res1$par

dtsm.results(lambda)
lambda.hat <- lambda

## optimization with M different starting values
M=5
obj.min <- 100000
for (i in 1:M) {
  cat("*** iteration ", i, "\n")
  ## random starting value: lambda_0 + noise
  lambda <- unreparam(starting.lamQ(N-2))
  cat("starting values = ", reparam(lambda), "\n")
  res <- optim(lambda, obj, control=list(trace=0,maxit=10000,reltol=1e-9))
  lambda <- res$par
#  res <- optim(lambda, obj, method="BFGS", control=list(trace=0,maxit=10000,reltol=1e-9))
#  lambda <- res$par

  cat("optimal values = ", reparam(lambda), "\n")
  cat("value of objective function = ", res$value, "\n")
  if (res$value < obj.min) {
    res.opt <- res
    obj.min <- res$value
    lambda.opt <- res$par
  }
}

res <- dtsm.results(lambda.opt)

## MLE VCV matrix
theta.hat <- res$theta.hat

library(numDeriv)
## second-derivative estimate of the information matrix
L <- function(theta)
  L <- sum(llk(theta))
(I.2D <- -T^-1*hessian(L, theta.hat, method.args=list(d=.0001)))
#print(I.2D)
ht <- jacobian(llk, theta.hat, method.args=list(d=.00001))
(I.OP <- crossprod(ht)/T)
(V.mle <- T^-1*solve(I.2D %*% solve(I.OP) %*% I.2D))
theta.se <- sqrt(diag(V.mle))
for (i in 1:length(theta.hat))
  cat(" theta(",i,") -- ", theta.hat[i], " [", theta.hat[i]-1.96*theta.se[i],", ", theta.hat[i]+1.96*theta.se[i], "] \n")

save(res, V.mle, theta.se, file=res.file)


