## initialize settings
## load data
## calculate daily changes
## calculate risk factors (PCs)

NQ <- 63  # for ED - number of days in the quarter -- average number of business days between rollover. max is 68
NM <- 21  # for FF
n.days <- NM*12   ## 252 trading days in a year

ed.contracts <- 2:15
ff.contracts <- 1:4

# mats <- seq(12,120,by=12)
mats <- c(6,12,18,24,36,48,60,72,84,96,108,120)  # in months

J1 <- length(ff.contracts)
J2 <- length(ed.contracts)
J3 <- length(mats)
J <- J1+J2+J3
Jind.ff <- 1:J1
Jind.ed <- (J1+1):(J1+J2)
Jind.y <- (J1+J2+1):J

N <- 3

## load data
start.date <- 19900102 # 19920701 (>16 ED contracts)
end.date <- 20091230

## load yield data
load("data/le_data_daily.RData")
y.data <- data.frame(dates, Y[,mats]*100)  ## in annualized percentage points
colnames(y.data) <- c('dates', mats)
rm(T, Y, dates, start.day)
mats.years <- mats/12
mats <- mats.years*n.days  # in days

## load Eurodollar futures
ed.data <- read.csv("data/EDdata_final.csv")
ed.data <- ed.data[ed.data[,1]>=start.date & ed.data[,1]<=end.date,]
ind.na <- rowSums(is.na(ed.data[,c(ed.contracts, max(ed.contracts)+1)+1]))>0  ## need one additional contract (for rollover)
ed.data <- ed.data[!ind.na,]

## load fed funds futures
ff.data <- read.csv("data/FFdata_final.csv")
ff.data <- ff.data[ff.data[,1]>=start.date & ff.data[,1]<=end.date,c(1,3:9)]
ind.na <- rowSums(is.na(ff.data[,c(ff.contracts, max(ff.contracts)+1)+1]))>0  ## need one additional contract (for rollover)
ff.data <- ff.data[!ind.na,]

## select sample for which all instruments have data
dates <- intersect(intersect(ff.data[,1],ed.data[,1]),y.data[,1])
T <- length(dates)
ff.data <- ff.data[match(dates, ff.data$date),]
ed.data <- ed.data[match(dates, ed.data$date),]
y.data <- y.data[match(dates, y.data$date),]

## combine data from different instruments
Y <- as.matrix( cbind(ff.data[,ff.contracts+1], ed.data[,ed.contracts+1], y.data[,2:(J3+1)]))
Y <- Y/100/n.days

## principal components
eig <- eigen(cov(Y))
W <- t(eig$vectors[,1:N])
P <- Y %*% t(W)   ## pricing factors are first three PCs

## calculate daily changes
dY <- rbind(0, Y[2:T,]-Y[1:(T-1),])

## correctly handle rollover days
## 1. for fed funds futures
months <- unique(floor(dates/100))
ind.ffroll <- matrix(FALSE, T, 1)
for (month in months)
  ind.ffroll[min(which(floor(dates/100)==month))] <- TRUE
i.ffroll <- which(ind.ffroll)
i.ffroll <- i.ffroll[2:length(i.ffroll)] ## ignore first day
dY[i.ffroll, Jind.ff] <- as.matrix(ff.data[i.ffroll,ff.contracts+1]-ff.data[i.ffroll-1,ff.contracts+2])/100/n.days
## 2. for ED futures
ind.edroll <- ed.data$roll_date==1
dY[ind.edroll, Jind.ed] <- as.matrix(ed.data[ind.edroll,ed.contracts+1]-ed.data[which(ind.edroll)-1,ed.contracts+2])/100/n.days

## create risk factors
dP <- dY %*% t(W)
