## analyze estimation results
## and produce all graphs and tables for paper

rm(list=ls())
graphics.off()

setwd("...")

## initialize settings, load data, create risk factors, load functions.
source("R/init.r")
source("R/dtsm_functions.r")
source("R/news_fns.r")

## load estimation results
load.list <- load("estimates/results_yfut_1aa.RData")
##  "res"      "V.mle"    "theta.se"

## figures for presentation
pres.width <- 1090
pres.height <- 800

## get parameters and loadings
PhiQ.X <- get.PhiQ.X(res$lamQ.X)
loads <- yfut.loadings(W, PhiQ.X, NA)

## loadings for revision (Q-expected short rate path)
mats.rev <- seq(n.days/12, n.days*10, by=n.days/12)  ## 1 to 120 months (in days)
M <- max(mats.rev)
loads1 <- gaussian.loadings(1:M, matrix(0,N,1), PhiQ.X, matrix(NA,N,N), res$rinfQ, rep(1,N))
## go from yield loadings to forward rate loadings
BfX <- cbind(loads1$B[,1], rep(1,N)%*%t(2:M) * loads1$B[,2:M] - rep(1,N)%*%t(1:(M-1)) * loads1$B[,1:(M-1)])  # N*M
BfX <- BfX[,mats.rev]

## calculate Jordan-normalized factors
dX <- dP%*% t(solve(W %*% t(loads$BX)))

## fitted rates, pricing errors
dY.hat <- dY.fitted(dP, P, W, PhiQ.X)
errors <- dY - dY.hat
sigma.e <- sqrt( sum(errors^2)/T/(J-N) )

## change scale -- everything in basis points
dP <- dP*n.days*10000
dX <- dX*n.days*10000
dY <- dY*10000*n.days
dY.hat <- dY.hat*10000*n.days
errors <- errors*10000*n.days
sigma.e <- sigma.e*10000*n.days

##################################################
## model fit

print("RMSE")
print(sqrt(mean(errors^2)))

print("SD of rate changes")
print(sd(dY))

##print("RMSE per instrument")
##sige.curve <- sqrt(colMeans(sq.errors))

##print("FF futures")
##print(sige.curve[Jind.ff]*10000*n.days)
##print("ED futures")
##print(sige.curve[Jind.ed])
##print("yields")
##print(sige.curve[Jind.y])

## R-squared
print("R-squared")
print(1-var(as.vector(errors))/var(as.vector(dY)))
##print(1-sigma.e^2/var(as.vector(dY)))

##print("R-squared per instrument")
##print(1 - diag(var(errors))/diag(var(dY)))

print("explanatory power of first three PCs:")
print(sum(eig$values[1:3])/sum(eig$values))

##################################################
## Main Analysis						##
## Create Figures 1, 2, 3, 4, 5, 6, & 7		##
## Create Tables 1 & 2					##
##################################################

require(plotrix)
plotUncondVolCurve(dY, dY.hat, dX, BfX)

#### policy vs. macro ####
to.latex <- FALSE
regimes <- createRegimes()  # Creates three CSV files
table(regimes)
plotVolCurves(dY, dY.hat, dX, BfX, dP, regimes) # Figure 3
testRegimes(dP, regimes)
compareRegimes(Omega.P, Omega.X, BfX)

#### policy ####

plotPolicySurprises(dY, dY.hat, dX, BfX)  # Figure 1
KuttnerRegressions(dY, dY.hat, dP, regimes)  # Figure 2

#### Macro ####
# Figure 4
plotMacroSurprises(dY, dY.hat, dX, BfX)
require(sandwich)
AnnouncementEffects(dY, dY.hat, dX, BfX, dP)  # Figure 5,6,7 & Table 1
analyzePolicyInertia(dX, BfX, regimes) # Table 2

# Table 3 can only be created with Onatski's code
