## estimate macro-finance Gaussian model
## - risk factors are first L PCs of yields and M macrofactors
## - PCs are observed
## - macro factors are observed
## - normalization as in JLS

rm(list=ls())
library(jls)
source("R/zlb_functions.r")
source("R/est_fns.r")
set.seed(616)

cL <- 2 ## number of yield factors in PL
init.jls(flag.subsmpl=TRUE, cL)
PL.o <- Y %*% t(WL)
Z <- cbind(M.o, PL.o)

est.date <- as.character(format(Sys.time(), "%Y%m%d"))
filename <- paste("estimates/jls_L", cL, ".RData", sep="")

cat("filename: ", filename, "\n")
cat("## Number of yield factors:", cL, "\n")

## (1) VAR for Z
ar1 <- ar.ols(Z, aic=FALSE, order.max=1, intercept=TRUE, demean=FALSE)
K1P <- ar1$ar[,,] - diag(cN)
K0P <- ar1$x.intercept
Omega <- ar1$var.pred
Sigma <- t(chol(Omega))

## (2) optimization over (rinfQ, lamQ, gam0, gam1, Sigma)
pars.start <- getStartingValuesJLS(Sigma)
theta.start <- pars2theta.jls(pars.start)
theta <- getOptim(theta.start, obj.jls)

## results
pars <- theta2pars.jls(theta)
pars$K0P <- K0P
pars$K1P <- K1P
pars$Omega <- pars$Sigma %*% t(pars$Sigma)

## likelihood observed model
res.llk <- jls.llk(Y, M.o, W, cL, rinfQ=pars$rinfQ, lamQ=pars$lamQ, gam0=pars$gam0, gam1=pars$gam1, Sigma=pars$Sigma, mats=mats, dt=1)
pars$sigma.e <- res.llk$sigma.e

save(file=filename, mats, dates, n.per, Y, M.o, cL, cM, cN, theta, pars, W)
