## estimate affine Gaussian model
## - risk factors first observed then filtered
## - maximally-flexible
## - JSZ canonical form

rm(list=ls())
library(jsz)
source("R/zlb_functions.r")
source("R/est_fns.r")
set.seed(616)

cN <- 3
init.jsz(flag.subsmpl=TRUE, cN)

cP <- Y %*% t(W)

est.date <- as.character(format(Sys.time(), "%Y%m%d"))
filename <- paste("estimates/jsz_N", cN, ".RData",sep="")

cat("filename: ", filename, "\n")

## (i) estimate VAR
ar1 <- ar.ols(cP, aic=FALSE, order.max=1, intercept=TRUE, demean=FALSE)
Phi.hat <- ar1$ar[,,]
mu.hat <- ar1$x.intercept
Sigma.hat <- t(chol(ar1$var.pred))

## (2) numerical optimization
theta.start <- pars2theta.jsz(getStartingValuesJSZ(Sigma.hat))
theta <- getOptim(theta.start, obj.jsz)

## results
pars <- theta2pars.jsz(theta)
pars$Phi <- Phi.hat
pars$mu <- mu.hat

## value of likelihood
res.llk <- jsz.llk(Y, W, K1Q.X=diag(pars$lamQ), Sigma.cP=pars$Omega,mats=mats,dt=1)
pars$kinfQ <- res.llk$K0Q.X[which(res.llk$K0Q.X!=0)]
pars$sigma.e <- res.llk$sigma.e

save(file=filename, Y, n.per, cN, mats, W, dates, theta, pars, res.llk)

## show results
cat("log-likelihood = ", -sum(res.llk$llk), " \n")
cat("k_inf^Q = ", pars$kinfQ, " \n")
cat("Q-eigenvalues: ", round(t(pars$lamQ)+1,digi=8), " \n")
cat("P-eigenvalues: ", round(eigen(pars$Phi)$values, digi=8), " \n")

T <- nrow(cP)
Yhat <- rep(1,T)%*%res.llk$AcP + cP%*%res.llk$BcP
cat("RMSE (bps) = ", 10000*n.per*sqrt( mean((Y-Yhat)^2) ),"\n")
