## Bauer and Rudebusch (2016, JMCB) "Monetary Policy Expectations at the Zero Lower Bound"
## produce tables and figures

rm(list=ls())
graphics.off()
source("R/zlb_functions.r")
plot.mode <- 0  ## figures: 0-screen, 1-PDF (pres), 2-EPS (paper)
to.latex <- FALSE  ## tables:  TRUE - export latex table

## Figure - working paper only
loadYieldData()
loadMacroData()
plotData(plot.mode)

start.date <- c(1985, 1)
zlb.start <- c(2008, 12)
zlb.ind <- dates>20081200
post.2007 <- dates>20080000

##################################################
### load models

filename.Y3 <- "jsz_N3.RData"
filename.M2 <- "jls_L2.RData"

af.models <- list(
    YA3 = load_model(filename.Y3, flag.zlb=0, flag.macro=0),
    MA2 = load_model(filename.M2, flag.zlb=0, flag.macro=1)
    )
af.models <- assignNames(af.models)

## ZLB models
zlb.models <- list(
    YZ3 = load_model(filename.Y3, flag.zlb=1, flag.macro=0, rmin=0),
    MZ2 = load_model(filename.M2, flag.zlb=1, flag.macro=1, rmin=0)
    )
zlb.models <- assignNames(zlb.models)

#####
model <- zlb.models$MZ2
##model <- zlb.models$YZ3
#####

## rmin models
rmins <- c(0,5,10,15,20,25)
y.rmin.models <- list()
m.rmin.models <- list()
for (rmin in rmins) {
    y.rmin.models[[paste("YZ(3)", rmin, sep="-")]] <- load_model(filename.Y3, flag.zlb=1, flag.macro=0, rmin=rmin/120000)
    m.rmin.models[[paste("MZ(2)", rmin, sep="-")]] <- load_model(filename.M2, flag.zlb=1, flag.macro=1, rmin=rmin/120000)
}
y.rmin.models <- assignNames(y.rmin.models)
m.rmin.models <- assignNames(m.rmin.models)

all.models <- c(af.models, zlb.models)
print(names(all.models))

##################################################
### results yields, shadow rates, mean/modal paths, ZLB wedge

## Table 1
printFit(all.models, to.latex)

## Table 2
printViolations(af.models, to.latex)

## Figure 1
plotViolations(af.models, plot.mode)

## Table 3
printForecastAccuracy(all.models, to.latex, dm.pairs=rbind( c(1, 3), c(2,4), c(1,2), c(3,4)))

## Figure - working paper only
plotShadowRates(y.rmin.models, m.rmin.models, plot.mode=plot.mode)

## Figure 2
plotShortRateDist(model, plot.mode, 20121231)

## Figure 3
plotPaths(model, plot.mode, plot.dates=c(20121231, 20131231), flag.P=TRUE)

## Figure - working paper only
plotShadowYields(model, plot.mode, c(20121231, 20131231))

## Figure 4 - shadow vs. fitted yield and wedge
plotShadowWedge(model, plot.mode)

## export shadow rates
## tmp1 <- s
## apply(y.rmin.models, function(m) m$s*1200)
## colnames(tmp1) <- names(y.rmin.models)
## tmp2 <- sapply(m.rmin.models, function(m) m$s*1200)
## colnames(tmp2) <- names(m.rmin.models)
## tmp <- cbind("dates"=dates, tmp1, tmp2)
## write.csv(tmp, "export/shadow_rates.csv")


###############################################
### liftoff

analyzeLiftoff(zlb.models)
analyzeLiftoff(y.rmin.models)
analyzeLiftoff(m.rmin.models)

## scatterLiftoff(m.rmin.models[['MZ(2)-0']], m.rmin.models[['MZ(2)-25']], plot.mode, "scatterLiftoff-rmin")
## scatterLiftoff(zlb.models$YZ3, zlb.models$MZ2, plot.mode, "scatterLiftoff")

## Figure 5
model <- getLiftoffDist(model, incl.P = TRUE)
plotLiftoffDist(model, plot.mode, date=20121231)

## Figure 6
plotLiftoff(model, plot.mode)

##################################################
## expected pace of tightening after liftoff

## Figure 7
plotPace(model, plot.mode)

##################################################
### export

## ## yields and macro variables used in the estimation
## colnames(Y) <- paste0("y_", mats, "m")
## df <- data.frame(dates, 1200*Y, 1200*M.o,
##                  1200*zlb.models$MZ2$cP,
##                  1200*zlb.models$YZ3$cP)
## names(df)[12:15] <- paste0("MZ2-X", 1:4)
## names(df)[16:18] <- paste0("YZ3-X", 1:3)
## write.csv(df, "export/yields_macro_factors.csv")

## ## Figure 1 -- violations ZLB
## plotViolations(af.models, plot.mode=0, export=TRUE)

## ## Figure 3
## plotPaths(model, plot.mode=0, plot.dates=c(20121231, 20131231), flag.P=TRUE, export=TRUE)

## ## Figure 4 - actual, shadow, and fitted 10-year yield
## mat <- 120; j <- which(mats==mat)
## A <- 1200*cbind(Y[, j], model$Y.hat[,j], model$Y.shadow[,j])
## A <- cbind(A, A[,2]-A[,3])
## colnames(A) <- paste("10y", c("actual", "fitted", "shadow", "wedge"))
## rownames(A) <- dates
## write.csv(A, "export/fig4_wedge.csv")

## ## Figure 6 and 7, including the forecasts from SPD and Macro Advisers
## plotLiftoff(model, plot.mode=0, export=TRUE)
## plotPace(model, plot.mode=0, export=TRUE)

