### Section 4 - Ludvigson & Ng
## Table 2, second panel
## Table 5

rm(list=ls())
source("R/robust_fns.r")
source("R/var_fns.r")
library(xtable)
set.seed(616)

lndata <- getLNdata() ## original data
estSize <- TRUE

## lndata <- getLNdata(beg=198501, end=201612)  ## later sample period, our data
## estSize <- FALSE

## write.csv(lndata, "data/export/ln.csv", row.names=FALSE)
## stop()

cat("rho(1) of PC1", acf(lndata$PC1, plot=FALSE)$acf[2], "\n")
cat("rho(1) of PC2", acf(lndata$PC2, plot=FALSE)$acf[2], "\n")

N <- 5

macro.vars <-  paste0("F", 1:8)
PCs <- paste0("PC", 1:N)
M <- 5000 # number of bootstrap replications

dgp <- getBootDGP(PCs, macro.vars, lndata)

fmla1 <- formula(paste("get(depvar) ~", paste(PCs, collapse="+")))
fmla2 <- formula(paste("get(depvar) ~", paste(c(PCs, macro.vars), collapse="+")))
regvars <- c(PCs, macro.vars)
K <- length(regvars)
depvar <- "xr.avg"
cat("# Dependent variable:", depvar, "\n")

## Bootstrap
rval <- bootstrapTest(fmla1, fmla2, lndata, dgp, depvar=depvar, adjR2=TRUE, M=M, estSize=estSize)
tbl <- rbind(rval$tblCoef, rval$tblSize)
if (estSize) {
    ## Power
    rval2 <- bootstrapTest(fmla1, fmla2, lndata, dgp, depvar=depvar, adjR2=TRUE, M=M, H0=FALSE, estSize=estSize)
    rownames(rval2$tblSize) <- gsub("Size", "Power", rownames(rval2$tblSize))
    tbl <- rbind(tbl, rval2$tblSize)
}

print(round(tbl, d=3))
printLatexTbl(tbl)

## R^2
print(round(rval$tblR2, digi=2))
cat("Data ", sprintf("& %3.2f ", rval$tblR2[1,c(1,3,5)]), "\\\\ \n")
cat("Bootstrap ", sprintf("& %3.2f", rval$tblR2[2,c(1,3,5)]), "\\\\ \n")
cat(sprintf("& (%3.2f, %3.2f)", rval$tblR2[3,c(1,3,5)], rval$tblR2[3,c(2,4,6)]), "\\\\ \n")
cat("\\hline \n")


