## out-of-sample forecasting
rm(list=ls())
source("R/robust_fns.r")

cat("# JPS\n")
df <- getJPSdata(2016)
X1.names <- c("PC1", "PC2", "PC3")
X2.names <- c("GRO", "INF")
depvars <- c("xr2", "xr5", "xr10", "xr.avg")
in.smpl <- df$yyyymm<=200712
rval1 <- doOOS(df, in.smpl, depvars, X1.names, X2.names, flag.plot=FALSE)

cat("# Ludvigson-Ng\n")
df <- getLNdata(end=201612)
X2.names <- paste0("F", 1:8)
depvars <- c("xr2", "xr3", "xr4", "xr5", "xr.avg")
in.smpl <- df$yyyymm<=200612
rval2 <- doOOS(df, in.smpl, depvars, X1.names, X2.names, flag.plot=FALSE)

cat("# Cochrane-Piazzesi\n")
cpdata <- getFBdata(196401, 201612)
X2.names <- c("PC4", "PC5")
depvars <- c("xr2", "xr3", "xr4", "xr5", "xr.avg")
in.smpl <- cpdata$yyyymm<=200212 ## last 12 months of CP sample are not used in their regressions (returns NA)
rval3 <- doOOS(cpdata, in.smpl, depvars, X1.names, X2.names)

cat("# Cieslak-Povala\n")
df <- getOwnCPoData(197111, 201612)
X2.names <- "trend"
depvars <- c("xr2", "xr5", "xr10", "xr.avg")
cpo.smpl <- df$yyyymm<=201012
rval4 <- doOOS(df, cpo.smpl, depvars, X1.names, X2.names, flag.plot=TRUE)

tbl <- rbind(rval1, rval2, rval3, rval4)
rownames(tbl) <- c("Joslin-Priebsch-Singleton", "Ludvigson-Ng", "Cochrane-Piazzesi", "Cieslak-Povala")
colnames(tbl) <- names(rval1)
tbl <- tbl[, c(3,4,7,1,2,14,15)]
print(round(tbl, 3))

require(xtable)
xtbl <- xtable(tbl, digi=c(0,3,3,3,0,0,3,3))
print(xtbl, include.rownames=TRUE, include.colnames=TRUE, only.contents=TRUE,
                sanitize.text.function=function(x){x})
