//Solving the model in "Capital Controls and Optimal Chinese Monetary Policy"
//by Chang, Liu, and Spiegel (2015 JME)

//Date: December 12, 2013
//Updated: May 3, 2016

//----------------------------------------------
//--  Declare varaibles, shocks,  and parameter 
//----------------------------------------------

var 
C L w R pi Lambda m q_m v Gam Gam_h Gam_f q ca X bstar b bstar_p bstar_g Y GDP mu psi ge by
Rstar Xstar
;

varexo eRs eXs;

parameters
beta Phi_m Phi_l eta chi phi theta_p Omega_p Omega_b alpha theta psi_bar
lambda_z ge_bar Rstar_bar Xstar_bar pistar 

//---- Steady-state values
C_ss L_ss w_ss R_ss pi_ss Lambda_ss m_ss q_m_ss v_ss Gam_ss Gam_h_ss Gam_f_ss q_ss ca_ss X_ss bstar_ss b_ss Y_ss GDP_ss mu_ss by_ss
bstar_p_ss bstar_g_ss psi_ss
//--- Parameters related to shock processes (autocorrelations and standard deviations)
rho_rs rho_xs
sigma_rs sigma_xs;

//----------------------------------------------------------------
//-- Calibrate parameters 
//----------------------------------------------------------------
[param, ss] = calib;
alpha=param(1);
chi=param(2);
beta=param(3);
eta=param(4);
theta_p=param(5);
Omega_p=param(6);
Omega_b=param(7);
phi=param(8);
Phi_m=param(9);
Phi_l=param(10);
psi_bar = param(11);
theta=param(12);

//---Steady state values
C_ss = ss(1);
L_ss = ss(2);
w_ss = ss(3);
R_ss = ss(4);
pi_ss = ss(5);
Lambda_ss = ss(6);
m_ss = ss(7);
q_m_ss = ss(8);
v_ss = ss(9);
Gam_ss = ss(10);
Gam_h_ss = ss(11);
Gam_f_ss = ss(12);
q_ss = ss(13);
ca_ss = ss(14);
X_ss = ss(15);
bstar_ss = ss(16);
b_ss = ss(17);
Y_ss = ss(18);
GDP_ss = ss(19);
mu_ss = ss(20);
lambda_z = ss(21);
Rstar_bar = ss(22);
pistar = ss(23);
Xstar_bar = ss(24);
ge_bar = ss(25);
G_bar = ss(26);
bstar_p_ss = ss(27);
bstar_g_ss = ss(28);
psi_ss = psi_bar;
by_ss=bstar_ss/GDP_ss;


//--- Parameters in shock processes 
rho_rs = 0.98;      // Persistence of foreign interest rate shock
rho_xs = 0.95;     //Persistence of foreign demand shock
sigma_rs = 0.01;  //Standard deviation of foreign interest rate shock
sigma_xs = 0.01;  //Standard deviation of foreign demand shock

//--------------------------------------------------------------------
//-- Model specification
//--------------------------------------------------------------------
model;

//Eq (1): Wage equation
w = eta*L+C;

//Eq (2): Money demand
(Phi_m/(m_ss*Lambda_ss))*exp(-m-Lambda) = 1-(beta/(lambda_z*pi_ss))*exp(Lambda(+1)-Lambda-pi(+1));

//Eq (3): Domestic Bond Euler equation
exp(Lambda(+1)-Lambda+R-pi(+1)) = 1 + (Omega_b/2)*(psi_bar*exp(psi)-psi_bar)^2+
Omega_b*(psi_bar*exp(psi)-psi_bar)*(1-psi_bar*exp(psi));

//Eq (4): Modified UIP condition:
Omega_b*psi_bar*(exp(psi)-1)=exp(Lambda(+1)-Lambda-pi(+1))*(exp(R)-exp(Rstar+ge(+1)));

//Eq (5): Marginal utility
Lambda = -C;

//Eq (6): Portfolio share
psi_bar*exp(psi) = b_ss*exp(b)/(b_ss*exp(b)+q_ss*bstar_p_ss*exp(q+bstar_p));

//Eq (7): Real marginal cost
v = phi*q_m + (1-phi)*w;

//Eq (8): Demand for labor input
w = v+Y-L;

//Eq (9): Intermediate input composite
Gam = alpha*Gam_h + (1-alpha)*Gam_f;

//Eq (10): Relative price of intermediate goods
q_m = (1-alpha)*q;

//Eq (11): Relative demand for imported intermedaite goods
q = Gam_h - Gam_f;

//Eq (12): Real exchange rate
q = q(-1) + ge -pi;

//Eq (13): Phillips curve relation
1 = exp(v)-(Omega_p/(theta_p*v_ss))*exp(C-Y)*(exp(pi)*(exp(pi)-1)-beta*exp(pi(+1))*(exp(pi(+1))-1));

//Eq (14): Current account
ca_ss*exp(ca) = X_ss*exp(X) - q_ss*Gam_f_ss*exp(q+Gam_f) + 
(q_ss*bstar_ss/(pistar*lambda_z))*exp(q+bstar(-1))*(Rstar_bar*exp(Rstar(-1))-1);


//Eq (15): Export demand
X = theta*q+Xstar;

//Eq (16): Foreign capital flows
ca_ss*exp(ca)=q_ss*exp(q)*bstar_ss*(exp(bstar)-(1/(pistar*lambda_z))*exp(bstar(-1)));

//Eq (17): Government budget constraint 
q_ss*exp(q)*bstar_g_ss*(exp(bstar_g)-exp(bstar_g(-1)+Rstar(-1))*Rstar_bar/(pistar*lambda_z))=
b_ss*exp(b)-(b_ss/beta)*exp(b(-1)+R(-1)-pi) + 
m_ss*exp(m)*(1-(1/mu_ss)*exp(-mu));

//Eq (18): Resource constraint

Y_ss*exp(Y) = C_ss*exp(C)+ Gam_h_ss*exp(Gam_h) + X_ss*exp(X) + 
C_ss*exp(C)*(Omega_p/2)*(exp(pi)-1)^2 + (b_ss*exp(b)+q_ss*bstar_p_ss*exp(q+bstar_p))*(Omega_b/2)*psi_bar^2*(exp(psi)-1)^2;

//Eq (19): foreign bond holdings
bstar_ss*exp(bstar) = bstar_p_ss*exp(bstar_p)+bstar_g_ss*exp(bstar_g);

//Eq (20): Aggregate production function
Y = phi*Gam + (1-phi)*L;

//Eq (21): GDP
GDP_ss *exp(GDP) = C_ss *exp(C) + X_ss *exp(X) - q_ss*Gam_f_ss*exp(q+Gam_f);

//Eq (22): Money market equilibrium (real balance growth)
m = m(-1) + mu - pi;

//Eq(23): nominal exchange rate growth:
ge = 0;

//Eq (24): Foreign bond to GDP ratio
by = bstar_p - GDP;

//Exogenous variables 

Rstar = rho_rs*Rstar(-1)+eRs;  // Foreign interest rate shock
Xstar = rho_xs*Xstar(-1) + eXs; //Foreign demand shock

end;

steady_state_model;
C=0;
L=0;
w=0;
R=0;
pi=0;
Lambda=0;
m=0;
q_m=0;
v=0;
Gam=0;
Gam_h=0;
Gam_f=0;
q=0;
ca=0;
X=0;
bstar=0;
b=0;
bstar_p=0;
bstar_g=0;
Y=0;
GDP=0;
mu=0;
psi=0;
ge=0;
Rstar=0;
Xstar=0;
end;

shocks;
var eRs; stderr sigma_rs; // Foreign interest rate shock
var eXs; stderr sigma_xs; //Foreign demand shock
end;

set_dynare_seed(1353658);

planner_objective(C + log(C_ss) - (Phi_l*L_ss^(1+eta)/(1+eta))*exp((1+eta)*L));
ramsey_policy(planner_discount=1, nograph, noprint, irf=20, periods=1000, instruments=(R));
welf = -(1/(1-beta))*C_ss*Phi_l*(eta/2)*L_ss^(eta-1)*oo_.var(2,2);

