% Mstlab file: plot_irfs.m


dynare Bench.mod

bench_eRs = -[oo_.irfs.GDP_eRs; oo_.irfs.pi_eRs; oo_.irfs.R_eRs; oo_.irfs.mu_eRs; oo_.irfs.q_eRs; oo_.irfs.ca_eRs]';
bench_eXs = -[oo_.irfs.GDP_eXs; oo_.irfs.pi_eXs; oo_.irfs.R_eXs; oo_.irfs.mu_eXs; oo_.irfs.q_eXs; oo_.irfs.ca_eXs]';
bench_welfare = welf;
bench_vol = [oo_.var(21,21), oo_.var(5,5), oo_.var(2, 2), oo_.var(13,13), oo_.var(14,14)];  
% variances of GDP, inflation, employment, real exchange rate, and current account
save bench_out bench_eRs bench_eXs bench_welfare bench_vol beta;

clear;

dynare Oca.mod

oca_eRs = -[oo_.irfs.GDP_eRs; oo_.irfs.pi_eRs; oo_.irfs.R_eRs; oo_.irfs.mu_eRs; oo_.irfs.q_eRs; oo_.irfs.ca_eRs]';
oca_eXs = -[oo_.irfs.GDP_eXs; oo_.irfs.pi_eXs; oo_.irfs.R_eXs; oo_.irfs.mu_eXs; oo_.irfs.q_eXs; oo_.irfs.ca_eXs]';
oca_welfare = welf;
oca_vol = [oo_.var(21,21), oo_.var(5,5), oo_.var(2, 2), oo_.var(13,13), oo_.var(14,14)];  
save oca_out oca_eRs oca_eXs oca_welfare oca_vol;
clear;

dynare Flex.mod

flex_eRs = -[oo_.irfs.GDP_eRs; oo_.irfs.pi_eRs; oo_.irfs.R_eRs; oo_.irfs.mu_eRs; oo_.irfs.q_eRs; oo_.irfs.ca_eRs]';
flex_eXs = -[oo_.irfs.GDP_eXs; oo_.irfs.pi_eXs; oo_.irfs.R_eXs; oo_.irfs.mu_eXs; oo_.irfs.q_eXs; oo_.irfs.ca_eXs]';
flex_welfare = welf;
flex_vol = [oo_.var(21,21), oo_.var(5,5), oo_.var(2, 2), oo_.var(13,13), oo_.var(14,14)];  
save flex_out flex_eRs flex_eXs flex_welfare flex_vol;

clear;

dynare Full.mod

full_eRs = -[oo_.irfs.GDP_eRs; oo_.irfs.pi_eRs; oo_.irfs.R_eRs; oo_.irfs.mu_eRs; oo_.irfs.q_eRs; oo_.irfs.ca_eRs]';
full_eXs = -[oo_.irfs.GDP_eXs; oo_.irfs.pi_eXs; oo_.irfs.R_eXs; oo_.irfs.mu_eXs; oo_.irfs.q_eXs; oo_.irfs.ca_eXs]';
full_welfare = welf;
full_vol = [oo_.var(21,21), oo_.var(5,5), oo_.var(2, 2), oo_.var(13,13), oo_.var(14,14)];  
save full_out full_eRs full_eXs full_welfare full_vol;

clear;
load bench_out.mat;
load oca_out.mat;
load flex_out.mat;
load full_out.mat;



xlabel={'Real GDP','Inflation', 'Nominal interest rate', 'Money growth', 'Real exchange rate', 'Current account'};
nsteps=20;
nvars=length(xlabel); 
ncolumn=2;

% -- Benchmark model ----

figure;
for i=1:nvars;
    subplot(nvars/ncolumn,ncolumn,i);
    plot(1:nsteps, bench_eRs(:,i),'-k','Linewidth', 1.2);
    title(char(xlabel(i)));
end;
print -depsc outfig_irfs_eRs_bench_6v.eps;
print -dpdf outfig_irfs_eRs_bench_6v.pdf;

figure;
for i=1:nvars;
    subplot(nvars/ncolumn,ncolumn,i);
    plot(1:nsteps, bench_eXs(:,i),'-k','Linewidth', 1.2);
    title(char(xlabel(i)));
end;
print -depsc outfig_irfs_eXs_bench_6v.eps;
print -dpdf outfig_irfs_eXs_bench_6v.pdf;


% --- Welfare gains from reform (in consumption equivalence, with benchmark
% regime welfare normalized to zero)

oca_gain =  100*(1-exp((1-beta)*(bench_welfare-oca_welfare)));
flex_gain =  100*(1-exp((1-beta)*(bench_welfare-flex_welfare)));
full_gain =  100*(1-exp((1-beta)*(bench_welfare-full_welfare)));

disp(' Welfare gains: open capital account, flex er, full reform');
disp(' ')
disp([oca_gain, flex_gain, full_gain])

disp(' ')
disp(' Macro volatilities: benchmark, open capital account, flex er, full reform');
disp(' ')
disp(sqrt([bench_vol', oca_vol', flex_vol', full_vol']))




