## Section 6 - Cochrane-Piazzesi
## Table 2, fourth panel
## Table 7

rm(list=ls())
graphics.off()
source("R/robust_fns.r")
source("R/var_fns.r")
set.seed(616)

cpdata <- getCPdata()   ## original sample
estSize <- TRUE

## cpdata <- getFBdata(198501, 201612)   ## later sample
## estSize <- FALSE

## write.csv(cpdata, "data/export/cp.csv", row.names=FALSE)
## stop()

M <- 5000
fmla1 <- xr.avg ~ PC1 + PC2 + PC3
fmla2 <- xr.avg ~ PC1 + PC2 + PC3 + PC4 + PC5

## bootstrap
dgp <- getBootDGP(c("PC1", "PC2", "PC3"), c("PC4", "PC5"), cpdata)
rval <- bootstrapTest(fmla1, fmla2, cpdata, dgp, M=M, estSize=estSize)
tbl <- rbind(rval$tblCoef, rval$tblSize)
if (estSize) {
    ## Power
    rval2 <- bootstrapTest(fmla1, fmla2, cpdata, dgp, M=M, H0=FALSE, estSize=estSize)
    rownames(rval2$tblSize) <- gsub("Size", "Power", rownames(rval2$tblSize))
    tbl <- rbind(tbl, rval2$tblSize)
}

print(round(rval$tblR2, digi=2))
print(round(tbl, digi=3))

printLatexTbl(tbl)

## R^2
print(round(rval$tblR2, digi=2))
cat("Data      ", sprintf("& %3.2f ", rval$tblR2[1,c(1,3,5)]), "\\\\ \n")
cat("Bootstrap ", sprintf("& %3.2f", rval$tblR2[2,c(1,3,5)]), "\\\\ \n")
cat("          ", sprintf("& (%3.2f, %3.2f)", rval$tblR2[3,c(1,3,5)], rval$tblR2[3,c(2,4,6)]), "\\\\ \n")
cat("\\hline \n")

