## Section 6
## Greenwood-Vayanos
## Table 12

rm(list=ls())
require(sandwich)
source("R/robust_fns.r")
source("R/var_fns.r")

M <- 5000 ## number of bootstrap replications

gvdata <- getGVdata()

fmlas <- list(rlt12 ~ weightedgdp + logy1yr,
              rlt12 ~ weightedgdp + logy1yr + tspreadlt,
              rxlt12 ~ weightedgdp + PC1 + PC2 + PC3,
              rxavg ~ weightedgdp + PC1 + PC2 + PC3)

vcovfn <- function(lm.) NeweyWest(lm., 36, prewhite=FALSE)

PCs <- c("PC1", "PC2", "PC3")
regvars <- c("logy1yr", "tspreadlt", PCs, "weightedgdp")
for (fmla in fmlas) {
    tbl <- matrix(NA, 5, length(regvars))
    colnames(tbl) <- regvars
    rownames(tbl) <- c("Coefficient", "HAC $t$-statistic", "HAC $p$-value", "IM $q=8$", "IM $q=16$")
    mod <- lm(fmla, gvdata)
    SEs <- sqrt(diag(vcovfn(mod)))
    tstats <- (mod$coef/SEs)[-1]
    tblMueller <- getMuellerTable(fmla, gvdata)
    colind <- match(colnames(tblMueller), colnames(tbl))
    tbl[1, colind] <- mod$coef[-1]
    tbl[2, colind] <- tstats
    tbl[3, colind] <- pt(abs(tstats), mod$df, lower.tail=FALSE)*2
    tbl[4:5, colind] <- tblMueller[-1,]
    cat("\\multicolumn{7}{l}{\\emph{Dependent variable:", as.character(fmla[[2]]), "}} \\\\ \n")
    printLatexTbl(tbl)
}

gvdata$xr.avg <- gvdata$rxavg  ## for bootstrap variable name needs to be xr.avg
fmla1 <- get(depvar) ~ PC1 + PC2 + PC3
fmla2 <- get(depvar) ~ PC1 + PC2 + PC3 + weightedgdp
depvar <- "xr.avg"
dgp <- getBootDGP(PCs, "weightedgdp", gvdata)

## add bootstrap analysis for last model
rval <- bootstrapTest(fmla1, fmla2, gvdata, dgp, depvar=depvar, vcovfn=vcovfn, M=M)
tbl <- rval$tblCoef[,1:4]
print(round(tbl, digi=3))
printLatexTbl(tbl, 3)



