## Section 3 - Joslin-Priebsch-Singleton
## Table B.1

rm(list=ls())
graphics.off()
source("R/robust_fns.r")
source("R/var_fns.r")
set.seed(616)

##jpsdata <- getJPSdata()
jpsdata <- getJPSdata(end.year=2016) # same data but later sample

regvars <- c("PC1", "PC2", "PC3", "GRO", "INF")
K <- length(regvars)
M <- 5000  # number of bootstrap replications

fmla1 <- get(depvar) ~ PC1 + PC2 + PC3
fmla2 <- get(depvar) ~ PC1 + PC2 + PC3 + GRO + INF
X1.names <- c("PC1", "PC2", "PC3")
X2.names <- c("GRO", "INF")

fmla <- xr.avg ~ PC1 + PC2 + PC3 + GRO + INF

dgpBC <- getBootDGP(X1.names, X2.names, jpsdata, control=list(BC=TRUE))
depvars <- paste0("xr", 2:10)
tblsR2 <- as.list(setNames(depvars, depvars))
for (depvar in depvars)
{
    cat("# Dependent variable:", depvar, "\n")
    rval <- bootstrapTest(fmla1, fmla2, jpsdata, dgpBC, depvar=depvar, adjR2=TRUE, M=M)
    tbl <- rval$tblR2
    print(round(tbl, digi=2))
    tblsR2[[depvar]] <- tbl
}

for (i in 1:(length(depvars))) {
    cat("\n")
    cat("Data         ")
    cat(sprintf("& %3.2f ", tblsR2[[i]][1, c(1,3,5)]), " \\\\ \n")
    cat("BC bootstrap ")
    cat(sprintf("& %3.2f", tblsR2[[i]][2, c(1,3,5)]), " \\\\ \n")
    cat("             ")
    cat(sprintf("& (%3.2f, %3.2f)", tblsR2[[i]][3, c(1,3,5)], tblsR2[[i]][3, c(2,4,6)]), " \\\\ \n")
    cat("\\midrule \n")
}




